/*******************************************************************************
Author: John Iselin
Updated: September 24, 2019

Goldman School of Public Policy 
Masters in Public Policy Program
Graduate Student Researcher for Hilary Hoynes

Project: Measure Mobility of Children using the PSID. 

PSID Public Data:
From PSID Individual Data 
	- Sex (1968 Only)
	- Person Number (1968 Only)
	- Interview number 
	- Sequence Number
	- Relationship to Head
	- Age 
	- Individual Weight
	- Education 
	- Year of Birth
	- Month of Birth 

PSID Confidential Data: (via 2010Census File)
	- County of residence by interview-number by year pairs. 
	- State of residence by interview-number by year pairs. 

Any questions can be directed to John Iselin at johniselin@berkeley.edu

*******************************************************************************/


*** Set-Up
capture log close
clear matrix
clear all
set more off

local name "fsp_mobility"
global db "U:\"
global code "U:\code\"
global data "U:\data\"
global public_i "P:\public\ind\2017\"
global public_f "P:\public\fam\2017\"
global restr_10 "P:\restricted\01_Geo-Tract\2010Census\"
global results "U:\results\"

cd "$db"
log using "${db}\`name'_set_up.log", text replace

disp "DateTime: $S_DATE $S_TIME"

** Step 1: 	Load Individual-Level Public PSID Data (via code provided)
** Note: 	Originally the do-file was named "IND2017ER.do"
** 			It was amended with a new file-path

do ${code}01_fsp_mobility_public_i

sum 
des

save ${data}psid_individual, replace
clear


** Step 2: 	Load Family-Level Restricted Geocode PSID Data (via code provided)
** Note: 	Originally the do-file was named "Geo10Tract.do"
** 			It was amended with a new file-path

do ${code}02_fsp_mobility_restr_geo 

save ${data}psid_geo, replace
clear

** Step 3: 	Clean Public PSID Data File
** Note:	This step involves both cleaning the individual files and merging 
**			this file with restricted geocode data. 

do ${code}03_fsp_mobility_clean

disp "DateTime: $S_DATE $S_TIME"

log close

log using "${db}\`name'_results.log", text replace

disp "DateTime: $S_DATE $S_TIME"

** Step 4: 	Produce Results 
** Note:	This step could include regressions results but they are left out. 

do ${code}04_fsp_mobility_results

disp "DateTime: $S_DATE $S_TIME"

clear
log close
